package org.msh.tb.reports2.variables;


import org.jboss.seam.Component;
import org.msh.reports.filters.FilterOperation;
import org.msh.reports.filters.FilterOption;
import org.msh.reports.filters.ValueHandler;
import org.msh.reports.filters.ValueIteratorInt;
import org.msh.reports.keys.Key;
import org.msh.reports.query.SQLDefs;
import org.msh.tb.AgeRangeHome;
import org.msh.tb.entities.AgeRange;
import org.msh.tb.reports2.FilterType;
import org.msh.tb.reports2.ReportResources;
import org.msh.tb.reports2.VariableImpl;

import java.util.ArrayList;
import java.util.List;

public class AgeRangeVariable extends VariableImpl {

    private AgeRangeHome ageRangeHome;

    public AgeRangeVariable() {
        super(ReportResources.VAR_AGERANGE, "AgeRange", "tbcase.age");
    }

    /* (non-Javadoc)
     * @see org.msh.tb.reports2.VariableImpl#createKey(java.lang.Object)
     */
    @Override
    public Key createKey(Object values, int iteration) {
        if (values == null) {
            return Key.asNull();
        }

        // get the age
        int age = (Integer)values;

        // find the range
        AgeRange ageRange = getAgeRangeHome().findRange(age);

        if (ageRange == null) {
            return Key.asNull();
        }

        return Key.of(ageRange.getId());
    }


    /**
     * Return the class that handles are ranges
     * @return
     */
    protected AgeRangeHome getAgeRangeHome() {
        if (ageRangeHome == null)
            ageRangeHome = (AgeRangeHome)Component.getInstance("ageRangeHome", true);
        return ageRangeHome;
    }


    /* (non-Javadoc)
     * @see org.msh.tb.reports2.VariableImpl#getDisplayText(java.lang.Object)
     */
    @Override
    public String getDisplayText(Key key) {
        // if it's null, return undefined
        if (key.isNull())
            return super.getDisplayText(key);

        Integer id = (Integer)key.getValue();
        for (AgeRange ageRange: getAgeRangeHome().getItems()) {
            // found the range ?
            if (ageRange.getId().equals(id)) {
                return ageRange.toString();
            }
        }

        // if range is not found, return undefined
        return super.getDisplayText(Key.asNull());
    }


    /* (non-Javadoc)
     * @see org.msh.tb.reports2.VariableImpl#getFilterType()
     */
    @Override
    public String getFilterType() {
        return FilterType.REMOTE_OPTIONS;
    }


    /* (non-Javadoc)
     * @see org.msh.tb.reports2.VariableImpl#getFilterOptions()
     */
    @Override
    public List<FilterOption> getFilterOptions(Object param) {
        AgeRangeHome home = getAgeRangeHome();

        List<FilterOption> lst = new ArrayList<FilterOption>();
        for (AgeRange ar: home.getItems()) {
            lst.add(new FilterOption(ar.getId(), ar.toString()));
        }

        return lst;
    }


    /* (non-Javadoc)
     * @see org.msh.tb.reports2.VariableImpl#compareValues(java.lang.Object, java.lang.Object)
     */
    @Override
    public int compareValues(Key key1, Key key2) {
        AgeRange range1 = getAgeRangeHome().findRangeById((Integer)key1.getValue());
        AgeRange range2 = getAgeRangeHome().findRangeById((Integer)key2.getValue());

        if ((range1 != null) && (range2 != null)) {
            return ((Integer) range1.getIniAge()).compareTo(range2.getIniAge());
        }

        return super.compareValues(key1, key2);
    }


    /* (non-Javadoc)
     * @see org.msh.tb.reports2.VariableImpl#prepareFilterQuery(org.msh.reports.query.SQLDefs, org.msh.reports.filters.FilterOperation, java.lang.Object)
     */
    @Override
    public void prepareFilterQuery(SQLDefs def, FilterOperation oper, ValueHandler value) {
        String sql = value.mapSqlOR(new ValueIteratorInt() {
            @Override
            public String iterateInt(Integer value, int index) {
                return hqlRestriction(value);
            }
        });

        def.addRestriction(sql);
    }


    /**
     * Create the restriction by age range
     * @param id
     * @return
     */
    private String hqlRestriction(Integer id) {
        // search for age range
        AgeRangeHome home = getAgeRangeHome();
        AgeRange range = home.findRangeById(id);
        if (range == null)
            throw new IllegalArgumentException("Age range not found: " + id);

        return "tbcase.age between " + range.getIniAge() + " and " + range.getEndAge();
    }

}
